/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.renderers;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.util.JCWordWrap;

public class WordWrapCellRenderer
implements CellRenderer {
    public void draw(Graphics graphics, CellInfo cellInfo, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = cellInfo.getFontMetrics();
        Rectangle rectangle = cellInfo.getDrawingArea();
        graphics.setFont(cellInfo.getFont());
        graphics.setColor(bl ? cellInfo.getSelectedForeground() : cellInfo.getForeground());
        string = JCWordWrap.wrapText(JCWordWrap.replace(string, "\n", " "), fontMetrics, rectangle.width, "\n", cellInfo.getHorizontalAlignment() != 2);
        fontMetrics.stringWidth(string);
        string.indexOf(10);
        if (string.indexOf(10) != -1) {
            int n = fontMetrics.getHeight();
            int n2 = 0;
            int n3 = n - 4;
            int n4 = cellInfo.getVerticalAlignment();
            int n5 = this.getHeight(fontMetrics, string);
            if (n4 == 1) {
                n3 += (rectangle.height - n5) / 2;
            } else if (n4 == 2) {
                n3 += rectangle.height - n5;
            }
            n4 = cellInfo.getHorizontalAlignment();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (n4 == 1) {
                    n2 = (rectangle.width - fontMetrics.stringWidth(string2)) / 2;
                } else if (n4 == 2) {
                    n2 = rectangle.width - fontMetrics.stringWidth(string2);
                }
                graphics.drawString(string2, n2, n3);
                n3 += n;
            }
            return;
        }
        int n = 0;
        int n6 = fontMetrics.getHeight() - 4;
        int n7 = cellInfo.getHorizontalAlignment();
        if (n7 == 2) {
            n += rectangle.width - fontMetrics.stringWidth(string);
        } else if (n7 == 1) {
            n += (rectangle.width - fontMetrics.stringWidth(string)) / 2;
        }
        n7 = cellInfo.getVerticalAlignment();
        if (n7 == 1) {
            n6 += (rectangle.height - fontMetrics.getHeight()) / 2;
        } else if (n7 == 2) {
            n6 += rectangle.height - fontMetrics.getHeight();
        }
        graphics.drawString(string, n, n6);
    }

    public int getHeight(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        return fontMetrics.getHeight() * n;
    }

    public int getWidth(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.indexOf(10) != -1) {
            int n;
            int n2 = 0;
            int n3 = 0;
            while ((n = string.indexOf(10, n2)) != -1) {
                n3 = Math.max(n3, fontMetrics.stringWidth(string.substring(n2, n)));
                n2 = n + 1;
            }
            return Math.max(n3, fontMetrics.stringWidth(string.substring(n2, string.length())));
        }
        return fontMetrics.stringWidth(string);
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = cellInfo.getFontMetrics();
        int n = cellInfo.getDrawingArea().width;
        string = JCWordWrap.wrapText(JCWordWrap.replace(string, "\n", " "), fontMetrics, n, "\n", cellInfo.getHorizontalAlignment() != 2);
        return new Dimension(this.getWidth(fontMetrics, string), this.getHeight(fontMetrics, string));
    }
}

